'use strict';

function BCPResultReportsModalCtrl($scope, $http, $window){
    var elementId = "#modal-result-reports";

    $scope.simpleReports = [];
    $scope.extendedReports = [];

    $scope.$on('ResultReports:showWindow', function(event, type){

        $http.get(appDev + '/front/rest/round_reports')
            .success(function(data){
                $scope.simpleReports = data.simpleReports;
                $scope.extendedReports = data.extendedReports;
                $scope.openModal();
            })
        ;

    });

    $scope.openModal = function(){
        angular.element(elementId).modal('show');
    }

    $scope.closeModal = function(){
        angular.element(elementId).modal('hide');
    }

    $scope.openReport = function(report){
        $window.open(appDev + '/report/' + report.product_code.code);
    }
}

BCPResultReportsModalCtrl.$inject = ['$scope', '$http', '$window'];
